/*****************************************************************************
*  LPC43xx SCT demo program
*
*  1. Use SCT timer to generate a center aligned PWM output signal @ SCT_OUT0
*  2. Every time JOY_UP (pin PC_11) goes high to low increase the duty cycle
*  3. Every time JOY_DOWN (pin PC_12) goes high to low decrease the duty cycle
*  4. SCT_OUT0 is connected to pin P2_8
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

int main (void)
{
  static uint8_t trg1 = 1;
  static uint8_t trg2 = 1;

    SystemCoreClockUpdate ();                          // update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);              // enable SCT clock in CCU1 

    MCB4300_Init();                                    // initialize MCB4300 board stuff
    SCT_Init();                                        // initialize SCT1

    while (1)                                          // loop forever
    {
        if (!(JOY_UP) && trg1)                         // JOY_UP high to low?
        {
            trg1 = 0;                                  // trigger JOY_UP low
            if (LPC_SCT->MATCHREL[1].L < 9)
                LPC_SCT->MATCHREL[1].L ++;             // increase PWM dutycycle
        }
        else if ((JOY_UP) && !trg1)                    // JOY_UP low to high?
        {
            trg1 = 1;                                  // trigger JOY_UP high
        }

        if (!(JOY_DOWN) && trg2)                       // JOY_DOWN high to low?
        {
            trg2 = 0;                                  // trigger JOY_DOWN low
            if (LPC_SCT->MATCHREL[1].L > 0)
                LPC_SCT->MATCHREL[1].L --;             // decrease PWM dutycycle
        }
        else if ((JOY_DOWN) && !trg2)                  // JOY_DOWN low to high?
        {
            trg2 = 1;                                  // trigger P0.1 high
        }
    }
}
